/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnclientadapter.commandline;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import javax.xml.parsers.DocumentBuilderFactory;
import org.tigris.subversion.svnclientadapter.ISVNStatus;
import org.tigris.subversion.svnclientadapter.SVNNodeKind;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNStatusKind;
import org.tigris.subversion.svnclientadapter.SVNUrl;
import org.tigris.subversion.svnclientadapter.commandline.CmdLineException;
import org.tigris.subversion.svnclientadapter.commandline.CmdLineXmlCommand;
import org.tigris.subversion.svnclientadapter.commandline.Helper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class CmdLineStatusFromXml
extends CmdLineXmlCommand
implements ISVNStatus {
    private SVNUrl url;
    private SVNRevision.Number lastChangedRevision;
    private Date lastChangedDate;
    private String lastCommitAuthor;
    private SVNStatusKind textStatus;
    private SVNStatusKind repositoryTextStatus;
    private SVNStatusKind propStatus;
    private SVNStatusKind repositoryPropStatus;
    private SVNRevision.Number revision;
    private String path;
    private SVNNodeKind nodeKind;
    private boolean copied;
    private SVNUrl urlCopiedFrom;
    private File conflictNew;
    private File conflictOld;
    private File conflictWorking;
    private String lockOwner;
    private Date lockCreationDate;
    private String lockComment;

    protected CmdLineStatusFromXml(String string) {
        this.path = string;
    }

    public File getConflictNew() {
        return this.conflictNew;
    }

    public File getConflictOld() {
        return this.conflictOld;
    }

    public File getConflictWorking() {
        return this.conflictWorking;
    }

    public boolean isCopied() {
        return this.copied;
    }

    public File getFile() {
        return new File(this.getPath()).getAbsoluteFile();
    }

    public String getLastCommitAuthor() {
        return this.lastCommitAuthor;
    }

    public Date getLastChangedDate() {
        return this.lastChangedDate;
    }

    public SVNRevision.Number getLastChangedRevision() {
        return this.lastChangedRevision;
    }

    public String getLockComment() {
        return this.lockComment;
    }

    public Date getLockCreationDate() {
        return this.lockCreationDate;
    }

    public String getLockOwner() {
        return this.lockOwner;
    }

    public SVNNodeKind getNodeKind() {
        return this.nodeKind;
    }

    public String getPath() {
        return this.path;
    }

    public SVNStatusKind getPropStatus() {
        return this.propStatus;
    }

    public SVNStatusKind getRepositoryPropStatus() {
        return this.repositoryPropStatus;
    }

    public SVNStatusKind getRepositoryTextStatus() {
        return this.repositoryTextStatus;
    }

    public SVNRevision.Number getRevision() {
        return this.revision;
    }

    public SVNStatusKind getTextStatus() {
        return this.textStatus;
    }

    public SVNUrl getUrl() {
        return this.url;
    }

    public SVNUrl getUrlCopiedFrom() {
        return this.urlCopiedFrom;
    }

    protected void setConflictNew(File file) {
        this.conflictNew = file;
    }

    protected void setConflictOld(File file) {
        this.conflictOld = file;
    }

    protected void setConflictWorking(File file) {
        this.conflictWorking = file;
    }

    protected void setCopied(boolean bl) {
        this.copied = bl;
    }

    protected void setLastCommitAuthor(String string) {
        this.lastCommitAuthor = string;
    }

    protected void setLastChangedDate(Date date) {
        this.lastChangedDate = date;
    }

    protected void setLastChangedRevision(SVNRevision.Number number) {
        this.lastChangedRevision = number;
    }

    protected void setLockComment(String string) {
        this.lockComment = string;
    }

    protected void setLockCreationDate(Date date) {
        this.lockCreationDate = date;
    }

    protected void setLockOwner(String string) {
        this.lockOwner = string;
    }

    protected void setNodeKind(SVNNodeKind sVNNodeKind) {
        this.nodeKind = sVNNodeKind;
    }

    protected void setPath(String string) {
        this.path = string;
    }

    protected void setPropStatus(SVNStatusKind sVNStatusKind) {
        this.propStatus = sVNStatusKind;
    }

    protected void setRepositoryPropStatus(SVNStatusKind sVNStatusKind) {
        this.repositoryPropStatus = sVNStatusKind;
    }

    protected void setRepositoryTextStatus(SVNStatusKind sVNStatusKind) {
        this.repositoryTextStatus = sVNStatusKind;
    }

    protected void setRevision(SVNRevision.Number number) {
        this.revision = number;
    }

    protected void setTextStatus(SVNStatusKind sVNStatusKind) {
        this.textStatus = sVNStatusKind;
    }

    protected void setUrl(SVNUrl sVNUrl) {
        this.url = sVNUrl;
    }

    protected void setUrlCopiedFrom(SVNUrl sVNUrl) {
        this.urlCopiedFrom = sVNUrl;
    }

    public static CmdLineStatusFromXml[] createStatuses(byte[] byArray) throws CmdLineException {
        ArrayList<CmdLineStatusFromXml> arrayList = new ArrayList<CmdLineStatusFromXml>();
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setValidating(false);
            InputSource inputSource = new InputSource(new ByteArrayInputStream(byArray));
            Document document = documentBuilderFactory.newDocumentBuilder().parse(inputSource);
            NodeList nodeList = document.getElementsByTagName("entry");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node;
                Node node2;
                Element element;
                Node node3;
                Node node4;
                Node node5 = nodeList.item(i);
                String string = node5.getAttributes().getNamedItem("path").getNodeValue();
                CmdLineStatusFromXml cmdLineStatusFromXml = new CmdLineStatusFromXml(string);
                Element element2 = CmdLineStatusFromXml.getFirstNamedElement(node5, "wc-status");
                if (element2 == null) {
                    throw new Exception("'wc-status' tag expected under 'entry'");
                }
                Node node6 = element2.getAttributes().getNamedItem("item");
                cmdLineStatusFromXml.setTextStatus(SVNStatusKind.fromString(node6.getNodeValue()));
                Node node7 = element2.getAttributes().getNamedItem("props");
                cmdLineStatusFromXml.setPropStatus(SVNStatusKind.fromString(node7.getNodeValue()));
                Node node8 = element2.getAttributes().getNamedItem("revision");
                if (node8 != null) {
                    cmdLineStatusFromXml.setRevision(Helper.toRevNum(node8.getNodeValue()));
                }
                cmdLineStatusFromXml.setCopied((node4 = element2.getAttributes().getNamedItem("copied")) != null && "true".equals(node4.getNodeValue()));
                Element element3 = CmdLineStatusFromXml.getFirstNamedElement(element2, "commit");
                if (element3 != null) {
                    node3 = element3.getAttributes().getNamedItem("revision");
                    cmdLineStatusFromXml.setLastChangedRevision(Helper.toRevNum(node3.getNodeValue()));
                    element = CmdLineStatusFromXml.getFirstNamedElement(element3, "author");
                    if (element != null) {
                        cmdLineStatusFromXml.setLastCommitAuthor(element.getFirstChild().getNodeValue());
                    }
                    if ((node2 = CmdLineStatusFromXml.getNextNamedElement(element, "date")) != null) {
                        cmdLineStatusFromXml.setLastChangedDate(Helper.convertXMLDate(node2.getFirstChild().getNodeValue()));
                    }
                }
                if ((node3 = CmdLineStatusFromXml.getNextNamedElement(element3, "lock")) != null) {
                    element = CmdLineStatusFromXml.getFirstNamedElement(node3, "token");
                    if (element == null) {
                        throw new Exception("'token' tag expected under 'lock'");
                    }
                    node2 = CmdLineStatusFromXml.getNextNamedElement(node3, "owner");
                    if (node2 == null) {
                        throw new Exception("'owner' tag expected under 'lock'");
                    }
                    cmdLineStatusFromXml.setLockOwner(node2.getFirstChild().getNodeValue());
                    node = CmdLineStatusFromXml.getNextNamedElement(node2, "comment");
                    cmdLineStatusFromXml.setLockComment(node != null ? node.getFirstChild().getNodeValue() : null);
                    Element element4 = CmdLineStatusFromXml.getNextNamedElement(node, "created");
                    cmdLineStatusFromXml.setLockCreationDate(Helper.convertXMLDate(element4 != null ? element4.getFirstChild().getNodeValue() : null));
                }
                if ((element = CmdLineStatusFromXml.getNextNamedElement(element2, "repos-status")) != null) {
                    node2 = element.getAttributes().getNamedItem("item");
                    cmdLineStatusFromXml.setRepositoryTextStatus(SVNStatusKind.fromString(node2.getNodeValue()));
                    node = element.getAttributes().getNamedItem("props");
                    cmdLineStatusFromXml.setRepositoryPropStatus(SVNStatusKind.fromString(node.getNodeValue()));
                }
                arrayList.add(cmdLineStatusFromXml);
            }
        }
        catch (Exception exception) {
            throw new CmdLineException(exception);
        }
        return arrayList.toArray(new CmdLineStatusFromXml[arrayList.size()]);
    }
}

